# 🚀 Core3Chip - Sistema de Consulta de Clientes

## ✅ **Interface Criada com Sucesso!**

### 🎨 **Características da Nova Interface:**

- **Design Material Design** - Interface moderna e elegante
- **Logo Core3Chip** - Utiliza o arquivo `chip.png` da pasta
- **Formulário de Consulta** - Campo para CPF/CNPJ + botão consultar
- **Requisição AJAX** - Consulta assíncrona ao arquivo `consulta.php`
- **Layout Responsivo** - Funciona em desktop e mobile
- **Exibição de Dados** - Formulário organizado com os dados retornados da API

### 🌐 **Como Usar:**

1. **Acesse:** `http://localhost:8000`
2. **Digite:** CPF ou CNPJ no campo de busca
3. **Clique:** "Consultar Cliente"
4. **Visualize:** Dados organizados na parte inferior

### 🔧 **Arquivos da Interface:**

- **`index.php`** - Interface principal (Material Design)
- **`consulta.php`** - API de consulta (já existia)
- **`chip.png`** - Logo da aplicação
- **`confApi.php`** - Configuração da API

### 🎯 **Funcionalidades:**

- ✅ **Busca por CPF/CNPJ**
- ✅ **Requisição AJAX automática**
- ✅ **Loading durante consulta**
- ✅ **Exibição de dados organizados**
- ✅ **Mensagens de sucesso/erro**
- ✅ **Interface responsiva**

### 📱 **Campos Exibidos:**

- ID do Cliente
- Nome/Razão Social
- CPF/CNPJ
- Email
- Telefone
- Status
- Data de Cadastro
- Última Atualização

### 🚀 **Para Iniciar o Servidor:**

```bash
php -S localhost:8000
```

### 🎉 **Resultado:**

**Interface Core3Chip funcionando perfeitamente com Material Design!**

---

**Desenvolvido com:** HTML5, CSS3, JavaScript, PHP, Material Design
**API:** IXCsoft WebserviceClient
**Logo:** chip.png



