# Debug da API de Recorrência Implementado

## Resumo das Implementações

Implementei sistema de debug detalhado para identificar exatamente onde está o problema na API de recorrência que continua retornando erro 405.

## Funcionalidades de Debug Adicionadas

### 1. Debug Visual no Frontend (`consumos.php`)
- **URL completa**: Exibe a URL exata sendo chamada
- **AccountId**: Mostra o valor do accountId sendo usado
- **Payload RAW**: Exibe o JSON exato sendo enviado

#### Exemplo de Saída:
```
DEBUG INFO:
URL: /api/Subscription/619D91CC-95AC-4276-BDFE-93BB32CE6FD0/recurrence
AccountId: 619D91CC-95AC-4276-BDFE-93BB32CE6FD0
Payload RAW:
{
  "enabled": false,
  "recurrenceType": "BILLET"
}
```

### 2. Debug Detalhado no Backend (`proxy-chip.php`)
- **Logs de métodos**: PUT, PATCH, POST, DELETE
- **Body das requisições**: Payload completo sendo enviado
- **Headers**: Todos os headers enviados
- **Tempo de resposta**: Duração das requisições
- **Códigos HTTP**: Status das respostas

#### Exemplo de Log:
```
2025-01-27 14:30:15 - proxy-chip.php: INICIO PUT para https://app.boramvno.com.br/appapi/api/Subscription/619D91CC-95AC-4276-BDFE-93BB32CE6FD0/recurrence em 14:30:15 com body: {"enabled":false,"recurrenceType":"BILLET"}
2025-01-27 14:30:16 - proxy-chip.php: FIM PUT para ... | Tempo: 1.2s | HTTP 405: {"error":"Method not allowed"}
```

## Como Utilizar o Debug

### 1. Acesso ao Debug Visual
1. Acesse `consumos.php`
2. Selecione "Dados da linha"
3. Insira um número de telefone
4. Clique em "Consultar"
5. Selecione "Desativar recorrência"
6. Clique em "Executar"
7. Observe a seção "DEBUG INFO" na resposta

### 2. Acesso aos Logs do Backend
1. Execute uma requisição de recorrência
2. Acesse o arquivo `api.log` no servidor
3. Procure pelos logs mais recentes com timestamp

### 3. Comando para Ver Logs:
```bash
tail -f api.log
# ou
cat api.log | grep recurrence
```

## Informações Capturadas

### Frontend:
- ✅ URL completa da API
- ✅ AccountId extraído dos dados
- ✅ Payload JSON formatado
- ✅ Método HTTP utilizado
- ✅ Resposta completa da API

### Backend:
- ✅ Token de autenticação
- ✅ Headers enviados
- ✅ Body da requisição
- ✅ Método HTTP (PUT/PATCH/POST)
- ✅ Tempo de resposta
- ✅ Status HTTP
- ✅ Resposta da API externa

## Métodos Suportados

### PUT (Principal)
- **Uso**: Atualização de recorrência
- **Body**: `{"enabled": false, "recurrenceType": "BILLET"}`
- **Header**: `Content-Type: application/json`

### PATCH (Alternativo)
- **Uso**: Atualização parcial
- **Body**: Mesmo payload
- **Header**: Mesmo header

### POST (Fallback)
- **Uso**: Criação/atualização
- **Body**: Mesmo payload
- **Header**: Mesmo header

## Análise do Erro 405

### Possíveis Causas:
1. **Método não suportado**: API não aceita PUT/PATCH/POST para essa rota
2. **Rota incorreta**: Endpoint pode estar errado
3. **AccountId inválido**: ID não corresponde a uma assinatura válida
4. **Autenticação**: Token pode estar inválido ou sem permissões
5. **Headers**: Content-Type ou Accept podem estar incorretos

### Próximos Passos:
1. **Verificar logs**: Analisar `api.log` para ver exatamente o que está sendo enviado
2. **Testar rota**: Verificar se a rota `/api/Subscription/{accountId}/recurrence` está correta
3. **Validar accountId**: Confirmar se o ID extraído é válido
4. **Documentação API**: Consultar documentação oficial da API Boramvno
5. **Teste direto**: Usar Postman ou cURL para testar a API diretamente

## Arquivos Modificados

### `consumos.php`:
- Adicionado debug visual com URL, AccountId e Payload
- Exibição formatada das informações de debug
- Mantém funcionalidade existente

### `proxy-chip.php`:
- Adicionado suporte explícito para PUT e PATCH
- Logs detalhados para todos os métodos
- Captura de body para métodos HTTP
- Timestamp e duração das requisições

## Como Interpretar os Resultados

### Se o Debug Mostrar:
- **URL correta**: Problema pode ser no método ou payload
- **AccountId válido**: Problema pode ser na API externa
- **Payload correto**: Problema pode ser no método HTTP
- **Erro 405**: Método não suportado pela API

### Se os Logs Mostrarem:
- **Token válido**: Autenticação funcionando
- **Body correto**: Payload está sendo enviado corretamente
- **Headers corretos**: Content-Type adequado
- **Erro 405**: API não aceita o método para essa rota

## Status

✅ **Debug frontend implementado**
✅ **Debug backend implementado**
✅ **Logs detalhados ativos**
✅ **Suporte a PUT/PATCH/POST**
✅ **Sistema pronto para análise**

Agora você pode executar uma tentativa de desativação de recorrência e ver exatamente:
- Qual URL está sendo chamada
- Qual accountId está sendo usado
- Qual payload está sendo enviado
- Qual método está sendo utilizado
- Qual resposta está sendo retornada

Isso nos permitirá identificar precisamente onde está o problema e como corrigi-lo.

