# 🔍 Consulta IXC Implementada em linhas.php

## 📋 **Resumo da Implementação**

A funcionalidade de consulta IXC foi implementada na página `linhas.php` para buscar o `cliente.id` através do CPF/CNPJ, além da consulta existente na Boramvno.

## 🚀 **Como Funciona**

### 1. **Fluxo de Execução**
- Usuário digita CPF/CNPJ e clica em "Consultar Cliente"
- Sistema executa consulta na Boramvno (funcionalidade existente)
- **NOVO**: Sistema automaticamente executa consulta na API IXC
- Resultado da consulta IXC é exibido em um campo visual elegante
- `cliente.id` é armazenado na variável global `window.__clienteIdIXC`

### 2. **Arquivos Criados/Modificados**
- ✅ **`consultar-ixc.php`** - Novo arquivo para consulta IXC
- ✅ **`linhas.php`** - Modificado para incluir consulta IXC
- ✅ **`confApi.php`** - Já existia (configurações IXC)
- ✅ **`WebserviceClient.php`** - Já existia (cliente IXC)

## 🔧 **Detalhes Técnicos**

### **Variável Armazenada**
```javascript
window.__clienteIdIXC = "ID_DO_CLIENTE_IXC"
```

### **API IXC Consultada**
```php
// Usa a instância $api já configurada em confApi.php
$params = array(
    'qtype' => 'cliente.cnpj_cpf',
    'query' => 'CPF_CNPJ_DIGITADO',
    'oper' => '=',
    'page' => '1',
    'rp' => '20',
    'sortname' => 'cliente.id',
    'sortorder' => 'desc',
    'grid_param' => json_encode([
        ['TB' => 'cliente.ativo', 'OP' => '=', 'P' => 'S']
    ])
);
```

### **Endpoint Consultado**
```
GET /webservice/v1/cliente
```

## 🎨 **Interface Visual**

### **Campo de Resultado IXC**
- **Localização**: Após os campos do cliente Boramvno
- **Estilo**: Caixa azul com bordas arredondadas
- **Status Visual**:
  - 🔵 **Aguardando**: Consulta em andamento
  - 🟢 **Sucesso**: Cliente encontrado (verde)
  - 🔴 **Erro**: Cliente não encontrado ou erro (vermelho)

### **Informações Exibidas**
- ✅ **ID IXC**: Valor do `cliente.id`
- ✅ **Nome**: Nome do cliente no IXC
- ✅ **CPF/CNPJ**: Documento consultado
- ✅ **Variável**: Código da variável armazenada

## 📊 **Logs no Console**

### **Cliente Encontrado**
```
✅ Cliente IXC encontrado!
📋 window.__clienteIdIXC = 12345
🔍 Dados completos: {success: true, cliente_id: "12345", ...}
```

### **Cliente Não Encontrado**
```
❌ Cliente IXC não encontrado
📋 window.__clienteIdIXC = null
🔍 Erro: Cliente não encontrado no IXC
```

### **Erro na Consulta**
```
💥 Erro na consulta IXC
📋 window.__clienteIdIXC = null
🔍 Erro: Mensagem de erro específica
```

## 🔍 **Como Testar**

1. **Acesse** `linhas.php`
2. **Digite** um CPF/CNPJ válido
3. **Clique** em "Consultar Cliente"
4. **Aguarde** a consulta Boramvno + IXC
5. **Verifique** o campo azul "Consulta IXC"
6. **Abra** o console (F12) para ver os logs
7. **Confirme** que `window.__clienteIdIXC` contém o valor

## 📝 **Próximos Passos**

A variável `window.__clienteIdIXC` está pronta para ser utilizada na **operação complexa** que será implementada no botão "Finalizar".

## ⚠️ **Observações Importantes**

- ✅ **Estrutura existente**: Mantida intacta
- ✅ **Consulta Boramvno**: Continua funcionando normalmente
- ✅ **Consulta IXC**: Executada automaticamente após Boramvno
- ✅ **Variável global**: Disponível em `window.__clienteIdIXC`
- ✅ **Tratamento de erros**: Implementado para todos os cenários
- ✅ **Interface visual**: Elegante e informativa

## 🔧 **Correções Implementadas**

### **Problema Identificado**
- O arquivo `consultar-ixc.php` estava criando uma nova instância da API com valores hardcoded
- Não estava usando a instância `$api` já configurada no `confApi.php`
- Parâmetros da consulta não incluíam o `grid_param` necessário
- **CRÍTICO**: Não estava aplicando máscaras ao CPF/CNPJ antes da consulta (API IXC espera formato com máscara)
- **CRÍTICO**: Estava esperando estrutura `rows` mas a API IXC retorna `registros`

### **Soluções Aplicadas**
- ✅ **Removido valores hardcoded** - Agora usa `confApi.php`
- ✅ **Adicionado `grid_param`** - Filtro para clientes ativos
- ✅ **Melhorado extração de dados** - Suporte a diferentes formatos de resposta
- ✅ **Adicionado logs de debug** - Para identificar problemas futuros
- ✅ **Corrigido aplicação de máscaras** - CPF/CNPJ com formato correto para API IXC
- ✅ **Corrigido estrutura da resposta** - API IXC retorna `registros`, não `rows`

### **Arquivo de Teste**
- ✅ **`teste-ixc.php`** - Para verificar se a API IXC está funcionando

## 🎯 **Status Atual**

**IMPLEMENTADO E FUNCIONAL** ✅

A consulta IXC está funcionando e o `cliente.id` está sendo armazenado na variável `window.__clienteIdIXC` conforme solicitado.
