# Alteração no Payload da API de Recorrência

## Resumo das Implementações

Implementei uma alteração no `consumos.php` para otimizar o payload enviado para a API de recorrência, diferenciando entre ativar e desativar recorrência.

## Funcionalidades Implementadas

### 1. Payload Condicional
- **Desativar recorrência**: Envia apenas campos essenciais
- **Ativar recorrência**: Inclui todos os campos necessários

### 2. Lógica de Seleção
- **Opção "desativar"**: `enabled: false` + `recurrenceType: "BILLET"`
- **Opção "ativar"**: `enabled: true` + `recurrenceType: "BILLET"` + `planId`

## Como Funciona

### Antes da Alteração:
```javascript
const putBody = {
    enabled: enabledValue,
    recurrenceType: 'BILLET',
    planId: planId  // Sempre incluído
};
```

### Depois da Alteração:
```javascript
let putBody;
if (opt === 'desativar') {
    // Para desativar recorrência, enviar apenas enabled e recurrenceType
    putBody = {
        enabled: false,
        recurrenceType: 'BILLET'
    };
} else {
    // Para ativar recorrência, incluir planId
    putBody = {
        enabled: true,
        recurrenceType: 'BILLET',
        planId: planId
    };
}
```

## Benefícios

### 1. Otimização de Payload
- **Menos dados**: Desativação envia apenas campos essenciais
- **Eficiência**: Reduz tamanho da requisição quando desnecessário
- **Clareza**: Payload mais limpo e focado

### 2. Melhor Experiência do Usuário
- **Feedback visual**: Diferenciação clara entre operações
- **Consistência**: Comportamento previsível para cada opção
- **Performance**: Requisições mais rápidas

### 3. Conformidade com API
- **Campos corretos**: Apenas dados necessários para cada operação
- **Validação**: Payload adequado para cada tipo de operação
- **Compatibilidade**: Mantém funcionalidade existente

## Casos de Uso

### Desativar Recorrência
- **Payload**: `{"enabled": false, "recurrenceType": "BILLET"}`
- **Uso**: Quando usuário quer parar renovação automática
- **Campos**: Mínimos necessários para desativação

### Ativar Recorrência
- **Payload**: `{"enabled": true, "recurrenceType": "BILLET", "planId": "..."}`
- **Uso**: Quando usuário quer reativar renovação automática
- **Campos**: Completos para ativação com plano específico

## Arquivos Modificados

- `consumos.php`: Lógica de payload condicional implementada

## Teste

Para testar as alterações:
1. Acesse `consumos.php`
2. Selecione "Dados da linha"
3. Escolha "Desativar recorrência"
4. Clique em "Executar"
5. Verifique no console que o payload contém apenas `enabled: false` e `recurrenceType: "BILLET"`
6. Teste com "Ativar recorrência" para ver payload completo

## Notas Técnicas

- Mantém compatibilidade com funcionalidade existente
- Não afeta outras operações do sistema
- Lógica condicional baseada no valor do radio button
- Payload otimizado para cada tipo de operação
- Código mais limpo e manutenível
